/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.server;

import com.ibm.hsc.rep.server.RxRequest;
import com.ibm.hsc.rep.server.RxResponse;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.snia.wbemcmd.xml.SocketProvider;

public class RxConnection {
    String m_hostname;
    int m_port;
    Socket m_sock;
    ObjectInputStream m_ois;
    ObjectOutputStream m_oos;

    public RxConnection(String string, int n) {
        this.m_hostname = string;
        this.m_port = n;
    }

    public void open() throws Exception {
        SocketProvider socketProvider = SocketProvider.getProvider();
        InetAddress inetAddress = InetAddress.getByName(this.m_hostname);
        if (socketProvider != null) {
            this.m_sock = socketProvider.createSocket(inetAddress, this.m_port);
            System.out.println("RxConnection: created socket from provider");
            System.out.println("RxConnection: socket=" + this.m_sock);
        } else {
            this.m_sock = new Socket(this.m_hostname, this.m_port);
            System.out.println("RxConnection: socket=" + this.m_sock);
        }
        this.m_ois = new ObjectInputStream(this.m_sock.getInputStream());
        this.m_oos = new ObjectOutputStream(this.m_sock.getOutputStream());
        System.out.println("socket connected: " + this.m_sock);
    }

    public RxResponse send(RxRequest rxRequest) throws Exception {
        this.m_oos.writeObject(rxRequest);
        RxResponse rxResponse = (RxResponse)this.m_ois.readObject();
        return rxResponse;
    }

    public void close() {
        try {
            this.m_sock.close();
        }
        catch (Exception exception) {
            System.out.println("RxConnection: failed to close socket");
        }
    }
}

